<?php
/* --------------------------------------------------------------
   TrackingCodes.php 2020-03-09
   Gambio GmbH
   http://www.gambio.de
   Copyright (c) 2020 Gambio GmbH
   Released under the GNU General Public License (Version 2)
   [http://www.gnu.org/licenses/gpl-2.0.html]
   --------------------------------------------------------------
*/

declare(strict_types=1);

namespace Gambio\Admin\TrackingCode\Interfaces;

use IteratorAggregate;
use JsonSerializable;
use Traversable;

/**
 * Interface TrackingCodes
 *
 * @package Gambio\Admin\TrackingCode\Interfaces
 */
interface TrackingCodes extends IteratorAggregate, JsonSerializable
{
    /**
     * Returns internal tracking codes as array iterator.
     *
     * @return Traversable
     */
    public function getIterator(): Traversable;
    
    
    /**
     * Returns internal tracking codes as array.
     *
     * @return TrackingCode[]
     */
    public function items(): array;
}